/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.SubCategoryListEntry;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5423;
import net.minecraft.class_5458;
import virtuoel.no_fog.NoFogClient;
import virtuoel.no_fog.api.NoFogConfig;
import virtuoel.no_fog.util.FogToggles;
import virtuoel.no_fog.util.I18nUtils;
import virtuoel.no_fog.util.NoFogConfigImpl;
import virtuoel.no_fog.util.ReflectionUtils;
import virtuoel.no_fog.util.TriState;
import virtuoel.no_fog.util.VersionUtils;

public class AutoConfigUtils {
    public static final Supplier<NoFogConfig> CONFIG = () -> (NoFogConfig)AutoConfig.getConfigHolder(NoFogConfigImpl.class).getConfig();
    private static final ConfigEntryBuilder ENTRY_BUILDER = ConfigEntryBuilder.create();

    public static void initialize() {
        AutoConfig.register(NoFogConfigImpl.class, GsonConfigSerializer::new);
        GuiRegistry registry = AutoConfig.getGuiRegistry(NoFogConfigImpl.class);
        registry.registerPredicateProvider(AutoConfigUtils::globalToggleEntry, f -> f.getName().equals("globalToggles"));
        registry.registerPredicateProvider(AutoConfigUtils::dimensionToggleMapEntries, f -> f.getName().equals("dimensionToggles"));
        registry.registerPredicateProvider(AutoConfigUtils::biomeToggleMapEntries, f -> f.getName().equals("biomeToggles"));
    }

    private static List<AbstractConfigListEntry> globalToggleEntry(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
        try {
            LinkedList<AbstractConfigListEntry> entries = new LinkedList<AbstractConfigListEntry>();
            entries.add((AbstractConfigListEntry)ENTRY_BUILDER.startSubCategory(I18nUtils.translate("text.no_fog.config.category.global", "Global settings"), AutoConfigUtils.addToggleEntries((FogToggles)field.get(config))).build());
            return entries;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return new LinkedList<AbstractConfigListEntry>();
        }
    }

    private static List<AbstractConfigListEntry> dimensionToggleMapEntries(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
        Map data = ReflectionUtils.getFieldValue(field, config, HashMap::new);
        LinkedList<AbstractConfigListEntry> entries = new LinkedList<AbstractConfigListEntry>();
        LinkedList<SubCategoryListEntry> dimensionEntries = new LinkedList<SubCategoryListEntry>();
        class_310 client = class_310.method_1551();
        List<String> ids = Arrays.asList(class_1937.field_25179.method_29177().toString(), class_1937.field_25180.method_29177().toString(), class_1937.field_25181.method_29177().toString());
        if (client != null && client.field_1687 != null) {
            try {
                class_2378 dimensionRegistry = ReflectionUtils.getDynamicRegistry((class_5423)client.field_1687, class_2378.field_25095);
                ids = dimensionRegistry.method_10235().stream().map(class_2960::toString).collect(Collectors.toList());
            }
            catch (Throwable e) {
                NoFogClient.LOGGER.catching(e);
            }
        }
        for (String id : ids) {
            data.computeIfAbsent(id, xva$0 -> new FogToggles(xva$0));
            dimensionEntries.add(ENTRY_BUILDER.startSubCategory(I18nUtils.literal(id, new Object[0]), AutoConfigUtils.addToggleEntries((FogToggles)data.get(id))).build());
        }
        entries.add((AbstractConfigListEntry)ENTRY_BUILDER.startSubCategory(I18nUtils.translate("text.no_fog.config.category.dimensions", "Dimension Type settings"), dimensionEntries).build());
        return entries;
    }

    private static List<AbstractConfigListEntry> biomeToggleMapEntries(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
        Map data = ReflectionUtils.getFieldValue(field, config, HashMap::new);
        LinkedList<AbstractConfigListEntry> entries = new LinkedList<AbstractConfigListEntry>();
        LinkedList<SubCategoryListEntry> biomeEntries = new LinkedList<SubCategoryListEntry>();
        class_310 client = class_310.method_1551();
        class_2378 biomeRegistry = class_5458.field_25933;
        if (client != null && client.field_1687 != null) {
            try {
                biomeRegistry = ReflectionUtils.getDynamicRegistry((class_5423)client.field_1687, class_2378.field_25114);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        List ids = biomeRegistry.method_10235().stream().collect(Collectors.toList());
        Collections.sort(ids, (l, r) -> class_1074.method_4662((String)class_156.method_646((String)"biome", (class_2960)l), (Object[])new Object[0]).compareTo(class_1074.method_4662((String)class_156.method_646((String)"biome", (class_2960)r), (Object[])new Object[0])));
        for (class_2960 id : ids) {
            String idStr = id.toString();
            data.computeIfAbsent(idStr, xva$0 -> new FogToggles(xva$0));
            biomeEntries.add(ENTRY_BUILDER.startSubCategory(I18nUtils.translate(class_156.method_646((String)"biome", (class_2960)id), class_156.method_646((String)"biome", (class_2960)id)), AutoConfigUtils.addToggleEntries((FogToggles)data.get(idStr))).setTooltip(new class_2561[]{I18nUtils.literal(idStr, new Object[0])}).build());
        }
        entries.add((AbstractConfigListEntry)ENTRY_BUILDER.startSubCategory(I18nUtils.translate("text.no_fog.config.category.biomes", "Biome settings"), biomeEntries).build());
        return entries;
    }

    private static List<AbstractConfigListEntry> addToggleEntries(FogToggles data) {
        LinkedList<AbstractConfigListEntry> entries = new LinkedList<AbstractConfigListEntry>();
        String enabledKey = "text.no_fog.config.default.enabled";
        String enabledDefault = "Default: enabled";
        String disabledKey = "text.no_fog.config.default.disabled";
        String disabledDefault = "Default: disabled";
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.sky_fog", data.skyFog, newValue -> {
            data.skyFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.enabled", "Default: enabled")));
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.terrain_fog", data.terrainFog, newValue -> {
            data.terrainFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.thick_fog", data.thickFog, newValue -> {
            data.thickFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.thick_fog.tooltip", "Enable thick fog"), I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.water_fog", data.waterFog, newValue -> {
            data.waterFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.lava_fog", data.lavaFog, newValue -> {
            data.lavaFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        if (VersionUtils.MINOR >= 17) {
            entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.powder_snow_fog", data.powderSnowFog, newValue -> {
                data.powderSnowFog = newValue;
            }, I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        }
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.blindness_fog", data.blindnessFog, newValue -> {
            data.blindnessFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.enabled", "Default: enabled")));
        if (VersionUtils.MINOR >= 19) {
            entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.darkness_fog", data.darknessFog, newValue -> {
                data.darknessFog = newValue;
            }, I18nUtils.translate("text.no_fog.config.default.enabled", "Default: enabled")));
        }
        return entries;
    }

    private static EnumListEntry<TriState> triStateEntry(String key, TriState value, Consumer<TriState> saveConsumer, class_2561 ... tooltip) {
        return ENTRY_BUILDER.startEnumSelector(I18nUtils.translate(key, key), TriState.class, (Enum)(value != null ? value : TriState.DEFAULT)).setDefaultValue((Enum)TriState.DEFAULT).setSaveConsumer(saveConsumer).setTooltip(tooltip).build();
    }
}

