/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.pac.gui;

import java.io.IOException;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_640;
import xaero.map.WorldMap;
import xaero.map.element.MapElementMenuRenderer;
import xaero.map.element.MapElementRenderer;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.pac.SupportOpenPartiesAndClaims;
import xaero.map.mods.pac.gui.PartyPlayerIconRenderer;
import xaero.map.mods.pac.gui.PlayerDynamicInfoMapElement;
import xaero.map.mods.pac.gui.PlayerDynamicInfoMenuRenderContext;
import xaero.map.mods.pac.gui.PlayerDynamicInfoRenderProvider;
import xaero.map.mods.pac.gui.PlayerDynamicInfoRenderer;

public final class PlayerDynamicInfoMapElementMenuRenderer
extends MapElementMenuRenderer<PlayerDynamicInfoMapElement, PlayerDynamicInfoMenuRenderContext> {
    private final SupportOpenPartiesAndClaims pac;
    private final PartyPlayerIconRenderer iconRenderer;
    private final PlayerDynamicInfoRenderer renderer;

    private PlayerDynamicInfoMapElementMenuRenderer(PlayerDynamicInfoRenderer renderer, PartyPlayerIconRenderer iconRenderer, SupportOpenPartiesAndClaims pac, PlayerDynamicInfoMenuRenderContext context, PlayerDynamicInfoRenderProvider<PlayerDynamicInfoMenuRenderContext> provider) {
        super(context, provider);
        this.pac = pac;
        this.iconRenderer = iconRenderer;
        this.renderer = renderer;
    }

    @Override
    public void onMapInit(GuiMap screen, List<GuiDropDown> dropdowns, class_310 mc, int width, int height) {
        super.onMapInit(screen, dropdowns, mc, width, height);
        CursorBox showPlayersTooltip = new CursorBox((class_2561)class_2561.method_43469((String)(WorldMap.settings.pacPlayers ? "gui.xaero_box_showing_pac_players" : "gui.xaero_box_hiding_pac_players"), (Object[])new Object[]{class_2561.method_43470((String)Misc.getKeyName(SupportMods.xaeroPac.getPacPlayerKeyBinding())).method_27694(s -> s.method_10977(class_124.field_1077))}), true);
        screen.addButton(new GuiTexturedButton(width - 173, height - 33, 20, 20, WorldMap.settings.pacPlayers ? 197 : 213, 48, 16, 16, WorldMap.guiTextures, b -> this.onShowPlayersButton(screen, width, height), () -> showPlayersTooltip));
    }

    public void onShowPlayersButton(GuiMap screen, int width, int height) {
        WorldMap.settings.pacPlayers = !WorldMap.settings.pacPlayers;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.method_25423(this.mc, width, height);
    }

    @Override
    protected void beforeMenuRender() {
    }

    @Override
    protected void afterMenuRender() {
    }

    @Override
    public void renderInMenu(PlayerDynamicInfoMapElement element, class_4587 matrixStack, class_437 gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, class_310 mc, boolean pressed, int textX) {
        PlayerDynamicInfoMapElement playerElement = element;
        class_640 info = mc.method_1562().method_2871(playerElement.getPlayerId());
        if (info != null) {
            class_1657 clientPlayer = mc.field_1687.method_18470(playerElement.getPlayerId());
            this.iconRenderer.renderIcon(matrixStack, clientPlayer, this.pac.getPartyPlayerIconManager().getPlayerSkin(clientPlayer, info));
        }
    }

    @Override
    protected void beforeFiltering() {
    }

    @Override
    public int menuStartPos(int height) {
        return height - 59;
    }

    @Override
    public int menuSearchPadding() {
        return 1;
    }

    @Override
    protected String getFilterPlaceholder() {
        return "gui.xaero_filter_players_by_name";
    }

    @Override
    protected MapElementRenderer<? super PlayerDynamicInfoMapElement, ?, ?> getRenderer(PlayerDynamicInfoMapElement element) {
        return this.renderer;
    }

    public static final class Builder {
        private SupportOpenPartiesAndClaims pac;
        private PlayerDynamicInfoRenderer renderer;

        private Builder() {
        }

        private Builder setDefault() {
            this.setPac(null);
            return this;
        }

        public Builder setPac(SupportOpenPartiesAndClaims pac) {
            this.pac = pac;
            return this;
        }

        public Builder setRenderer(PlayerDynamicInfoRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public PlayerDynamicInfoMapElementMenuRenderer build() {
            if (this.pac == null || this.renderer == null) {
                throw new IllegalStateException();
            }
            return new PlayerDynamicInfoMapElementMenuRenderer(this.renderer, new PartyPlayerIconRenderer(), this.pac, new PlayerDynamicInfoMenuRenderContext(), new PlayerDynamicInfoRenderProvider<PlayerDynamicInfoMenuRenderContext>(this.pac));
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

