/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.settings.ModSettings;
import xaero.map.WorldMap;
import xaero.map.element.MapElementMenuRenderer;
import xaero.map.element.MapElementRenderer;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.IDropDownCallback;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuRenderContext;
import xaero.map.mods.gui.WaypointMenuRenderProvider;
import xaero.map.mods.gui.WaypointRenderer;

public class WaypointMenuRenderer
extends MapElementMenuRenderer<Waypoint, WaypointMenuRenderContext> {
    private final WaypointRenderer renderer;

    public WaypointMenuRenderer(WaypointMenuRenderContext context, WaypointMenuRenderProvider provider, WaypointRenderer renderer) {
        super(context, provider);
        this.renderer = renderer;
    }

    public void onMapInit(GuiMap screen, List<GuiDropDown> dropdowns, class_310 mc, int width, int height, WaypointWorld waypointWorld, AXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        GuiDropDown setsDropdown;
        super.onMapInit(screen, dropdowns, mc, width, height);
        boolean canCreate = SupportMods.xaeroMinimap.compatibilityVersion >= 6;
        GuiWaypointSets sets = waypointWorld != null ? new GuiWaypointSets(canCreate, waypointWorld) : null;
        IDropDownCallback setsDropdownCallback = null;
        if (sets != null) {
            setsDropdownCallback = (menu, selected) -> {
                if (canCreate && selected == menu.size() - 1) {
                    GuiNewSet guiNewSet = new GuiNewSet(modMain, minimapSession, (class_437)screen, (class_437)screen, waypointWorld);
                    class_310.method_1551().method_1507((class_437)guiNewSet);
                    return false;
                }
                sets.setCurrentSet(selected);
                waypointWorld.setCurrent(sets.getCurrentSetKey());
                minimapSession.getWaypointsManager().updateWaypoints();
                try {
                    modMain.getSettings().saveWaypoints(waypointWorld);
                }
                catch (IOException e) {
                    WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                }
                return true;
            };
        }
        GuiDropDown guiDropDown = setsDropdown = sets == null ? null : new GuiDropDown(sets.getOptions(), width - 173, height - 56, 151, sets.getCurrentSet(), true, setsDropdownCallback, true);
        if (setsDropdown != null) {
            dropdowns.add(setsDropdown);
        }
        class_5250 fullWaypointMenuTooltipText = class_2561.method_43469((String)"gui.xaero_box_full_waypoints_menu", (Object[])new Object[]{class_2561.method_43470((String)Misc.getKeyName(ModSettings.keyWaypoints)).method_27692(class_124.field_1077)});
        CursorBox fullWaypointMenuTooltip = new CursorBox((class_2561)fullWaypointMenuTooltipText, true);
        CursorBox onlyCurrentMapWaypointsTooltip = new CursorBox(WorldMap.settings.onlyCurrentMapWaypoints ? "gui.xaero_box_only_current_map_waypoints" : "gui.xaero_box_waypoints_selected_by_minimap", class_2583.field_24360, true);
        CursorBox renderingWaypointsTooltip = new CursorBox((class_2561)class_2561.method_43469((String)(WorldMap.settings.renderWaypoints ? "gui.xaero_box_rendering_waypoints" : "gui.xaero_box_not_rendering_waypoints"), (Object[])new Object[]{class_2561.method_43470((String)Misc.getKeyName(ModSettings.keyToggleMapWaypoints)).method_27692(class_124.field_1077)}), true);
        CursorBox renderAllSetsTooltip = new CursorBox((class_2561)class_2561.method_43469((String)(!modMain.getSettings().renderAllSets ? "gui.xaero_box_rendering_current_set" : "gui.xaero_box_rendering_all_sets"), (Object[])new Object[]{class_2561.method_43470((String)Misc.getKeyName(ModSettings.keyAllSets)).method_27692(class_124.field_1077)}), true);
        CursorBox showingDisabledTooltip = new CursorBox(WorldMap.settings.showDisabledWaypoints ? "gui.xaero_box_showing_disabled" : "gui.xaero_box_hiding_disabled", class_2583.field_24360, true);
        CursorBox closeWhenHoppingTooltip = new CursorBox(WorldMap.settings.closeWaypointsWhenHopping ? "gui.xaero_box_closing_menu_when_hopping" : "gui.xaero_box_not_closing_menu_when_hopping", class_2583.field_24360, true);
        screen.addButton(new GuiTexturedButton(width - 173, height - 20, 20, 20, 229, 0, 16, 16, WorldMap.guiTextures, b -> this.onFullMenuButton(b, screen), () -> fullWaypointMenuTooltip));
        screen.addButton(new GuiTexturedButton(width - 153, height - 20, 20, 20, WorldMap.settings.onlyCurrentMapWaypoints ? 213 : 229, 16, 16, 16, WorldMap.guiTextures, b -> this.onCurrentMapWaypointsButton(b, screen, width, height), () -> onlyCurrentMapWaypointsTooltip));
        screen.addButton(new GuiTexturedButton(width - 133, height - 20, 20, 20, WorldMap.settings.renderWaypoints ? 229 : 213, 48, 16, 16, WorldMap.guiTextures, b -> this.onRenderWaypointsButton(screen, width, height), () -> renderingWaypointsTooltip));
        screen.addButton(new GuiTexturedButton(width - 113, height - 20, 20, 20, !modMain.getSettings().renderAllSets ? 81 : 97, 16, 16, 16, WorldMap.guiTextures, b -> this.onRenderAllSetsButton(b, screen, width, height), () -> renderAllSetsTooltip));
        screen.addButton(new GuiTexturedButton(width - 93, height - 20, 20, 20, WorldMap.settings.showDisabledWaypoints ? 133 : 149, 16, 16, 16, WorldMap.guiTextures, b -> this.onShowDisabledButton(b, screen, width, height), () -> showingDisabledTooltip));
        screen.addButton(new GuiTexturedButton(width - 73, height - 20, 20, 20, WorldMap.settings.closeWaypointsWhenHopping ? 181 : 197, 16, 16, 16, WorldMap.guiTextures, b -> this.onCloseMenuWhenHoppingButton(b, screen, width, height), () -> closeWhenHoppingTooltip));
    }

    public void onRenderWaypointsButton(GuiMap screen, int width, int height) {
        WorldMap.settings.renderWaypoints = !WorldMap.settings.renderWaypoints;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.method_25423(this.mc, width, height);
    }

    private void onFullMenuButton(class_4185 b, GuiMap screen) {
        SupportMods.xaeroMinimap.openWaypointsMenu(this.mc, screen);
    }

    private void onRenderAllSetsButton(class_4185 b, GuiMap screen, int width, int height) {
        SupportMods.xaeroMinimap.handleMinimapKeyBinding(ModSettings.keyAllSets, screen);
    }

    private void onShowDisabledButton(class_4185 b, GuiMap screen, int width, int height) {
        WorldMap.settings.showDisabledWaypoints = !WorldMap.settings.showDisabledWaypoints;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.method_25423(this.mc, width, height);
    }

    private void onCloseMenuWhenHoppingButton(class_4185 b, GuiMap screen, int width, int height) {
        WorldMap.settings.closeWaypointsWhenHopping = !WorldMap.settings.closeWaypointsWhenHopping;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.method_25423(this.mc, width, height);
    }

    private void onCurrentMapWaypointsButton(class_4185 b, GuiMap screen, int width, int height) {
        WorldMap.settings.onlyCurrentMapWaypoints = !WorldMap.settings.onlyCurrentMapWaypoints;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.method_25423(this.mc, width, height);
    }

    @Override
    public void renderInMenu(Waypoint element, class_4587 matrixStack, class_437 gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, class_310 mc, boolean pressed, int textX) {
        Waypoint w = element;
        boolean disabled = w.isDisabled();
        boolean temporary = w.isTemporary();
        int type = w.getType();
        int color = w.getColor();
        String symbol = w.getSymbol();
        matrixStack.method_22904(-4.0, -4.0, 0.0);
        RenderSystem.enableBlend();
        if (type == 1) {
            class_332.method_25294((class_4587)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)color);
            RenderSystem.setShaderTexture((int)0, (class_2960)Waypoint.minimapTextures);
            RenderSystem.setShaderColor((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            gui.method_25302(matrixStack, 1, 1, 0, 78, 9, 9);
            RenderSystem.setShaderColor((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            gui.method_25302(matrixStack, 0, 0, 0, 78, 9, 9);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.disableTexture();
            class_332.method_25294((class_4587)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)color);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type != 1) {
            mc.field_1772.method_1720(matrixStack, symbol, (float)(5 - mc.field_1772.method_1727(symbol) / 2), 1.0f, -1);
        }
        RenderSystem.enableBlend();
        int infoIconOffset = 10;
        if (disabled) {
            RenderSystem.enableTexture();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)WorldMap.guiTextures);
            gui.method_25302(matrixStack, textX - 1 - infoIconOffset, 0, 173, 16, 8, 8);
            infoIconOffset += 10;
        }
        if (temporary) {
            RenderSystem.enableTexture();
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)WorldMap.guiTextures);
            gui.method_25302(matrixStack, textX - 1 - infoIconOffset, 0, 165, 16, 8, 8);
            infoIconOffset += 10;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int menuStartPos(int height) {
        return height - 59;
    }

    @Override
    public int menuSearchPadding() {
        return 14;
    }

    @Override
    protected String getFilterPlaceholder() {
        return "gui.xaero_filter_waypoints_by_name";
    }

    @Override
    protected MapElementRenderer<? super Waypoint, ?, ?> getRenderer(Waypoint element) {
        return this.renderer;
    }

    @Override
    protected void beforeFiltering() {
    }

    @Override
    protected void beforeMenuRender() {
    }

    @Override
    protected void afterMenuRender() {
    }
}

