/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.util.ScaleUtils;

public class ScaleRenderUtils {
    private static final Set<class_1792> loggedItems = ConcurrentHashMap.newKeySet();
    private static class_1799 lastRenderedStack = null;
    private static int itemRecursionDepth = 0;
    private static int maxItemRecursionDepth = 2;
    private static final Set<class_1299<?>> loggedEntityTypes = ConcurrentHashMap.newKeySet();
    private static class_1299<?> lastRenderedEntity = null;
    private static int entityRecursionDepth = 0;
    private static int maxEntityRecursionDepth = 2;

    public static final float modifyProjectionMatrixDepthByWidth(float depth, @Nullable class_1297 entity, float tickDelta) {
        return entity == null ? depth : ScaleRenderUtils.modifyProjectionMatrixDepth(ScaleUtils.getBoundingBoxWidthScale(entity, tickDelta), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepthByHeight(float depth, @Nullable class_1297 entity, float tickDelta) {
        return entity == null ? depth : ScaleRenderUtils.modifyProjectionMatrixDepth(ScaleUtils.getEyeHeightScale(entity, tickDelta), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepth(float depth, @Nullable class_1297 entity, float tickDelta) {
        return entity == null ? depth : ScaleRenderUtils.modifyProjectionMatrixDepth(Math.min(ScaleUtils.getBoundingBoxWidthScale(entity, tickDelta), ScaleUtils.getEyeHeightScale(entity, tickDelta)), depth, entity, tickDelta);
    }

    public static final float modifyProjectionMatrixDepth(float scale, float depth, class_1297 entity, float tickDelta) {
        if (scale < 1.0f) {
            return Math.max(depth * scale, (float)PehkuiConfig.CLIENT.minimumCameraDepth.get().doubleValue());
        }
        return depth;
    }

    public static void logIfItemRenderCancelled() {
        class_1792 i;
        if (lastRenderedStack != null && itemRecursionDepth >= maxItemRecursionDepth && !loggedItems.contains(i = lastRenderedStack.method_7909())) {
            String itemKey;
            String stackKey = lastRenderedStack.method_7922();
            if (stackKey.equals(itemKey = lastRenderedStack.method_7909().method_7876())) {
                Pehkui.LOGGER.fatal("[{}]: Did something cancel item rendering early? Matrix stack was not popped after rendering item {} ({}).", new Object[]{"pehkui", stackKey, lastRenderedStack.method_7909()});
            } else {
                Pehkui.LOGGER.fatal("[{}]: Did something cancel item rendering early? Matrix stack was not popped after rendering item {} ({}) ({})", new Object[]{"pehkui", stackKey, itemKey, lastRenderedStack.method_7909()});
            }
            loggedItems.add(i);
        }
    }

    public static void saveLastRenderedItem(class_1799 currentStack) {
        if (itemRecursionDepth == 0) {
            lastRenderedStack = currentStack;
        }
        ++itemRecursionDepth;
    }

    public static void clearLastRenderedItem() {
        lastRenderedStack = null;
        itemRecursionDepth = 0;
    }

    public static void logIfEntityRenderCancelled() {
        if (lastRenderedEntity != null && entityRecursionDepth >= maxEntityRecursionDepth && !loggedEntityTypes.contains(lastRenderedEntity)) {
            class_2960 id = class_1299.method_5890(lastRenderedEntity);
            Pehkui.LOGGER.fatal("[{}]: Did something cancel entity rendering early? Matrix stack was not popped after rendering entity {}.", new Object[]{"pehkui", id});
            loggedEntityTypes.add(lastRenderedEntity);
        }
    }

    public static void saveLastRenderedEntity(class_1299<?> type) {
        if (entityRecursionDepth == 0) {
            lastRenderedEntity = type;
        }
        ++entityRecursionDepth;
    }

    public static void clearLastRenderedEntity() {
        lastRenderedEntity = null;
        entityRecursionDepth = 0;
    }

    public static void addDetailsToCrashReport(class_129 section) {
        if (lastRenderedStack != null) {
            section.method_578("pehkui:debug/render/item", (Object)lastRenderedStack.method_7909().method_7876());
        }
        if (lastRenderedEntity != null) {
            class_2960 id = class_1299.method_5890(lastRenderedEntity);
            section.method_578("pehkui:debug/render/entity", (Object)id);
        }
    }
}

