/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.biome.BoxBlur;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4543;
import net.minecraft.class_6539;
import net.minecraft.class_6880;

public class BlockColorCache {
    private static final int BORDER = 1;
    private final class_6880<class_1959>[][] biomes;
    private final Map<class_6539, int[][]> colors;
    private final int sizeHorizontal;
    private final int sizeVertical;
    private final int blurHorizontal;
    private final int baseX;
    private final int baseY;
    private final int baseZ;
    private final WorldSlice slice;

    public BlockColorCache(WorldSlice slice, int radius) {
        this.slice = slice;
        int borderXZ = radius + 1;
        int borderY = 1;
        this.sizeHorizontal = 16 + borderXZ * 2;
        this.sizeVertical = 16 + borderY * 2;
        this.blurHorizontal = radius;
        class_4076 pos = slice.getOrigin();
        this.baseX = pos.method_19527() - borderXZ;
        this.baseY = pos.method_19528() - borderY;
        this.baseZ = pos.method_19529() - borderXZ;
        this.colors = new Reference2ReferenceOpenHashMap();
        this.biomes = new class_6880[this.sizeVertical][];
    }

    public int getColor(class_6539 resolver, int posX, int posY, int posZ) {
        int[] layer;
        int x = class_3532.method_15340((int)(posX - this.baseX), (int)0, (int)this.sizeHorizontal);
        int y = class_3532.method_15340((int)(posY - this.baseY), (int)0, (int)this.sizeVertical);
        int z = class_3532.method_15340((int)(posZ - this.baseZ), (int)0, (int)this.sizeHorizontal);
        Object colors = this.colors.get(resolver);
        if (colors == null) {
            int[][] nArrayArray = new int[this.sizeVertical][];
            colors = nArrayArray;
            this.colors.put(resolver, nArrayArray);
        }
        if ((layer = colors[y]) == null) {
            layer = this.gatherColorsXZ(resolver, y);
            colors[y] = layer;
        }
        return layer[this.indexXZ(x, z)];
    }

    private class_6880<class_1959>[] gatherBiomes(int level) {
        class_4543 biomeAccess = this.slice.getBiomeAccess();
        class_6880[] biomeData = new class_6880[this.sizeHorizontal * this.sizeHorizontal];
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = 0; x < this.sizeHorizontal; ++x) {
            for (int z = 0; z < this.sizeHorizontal; ++z) {
                biomeData[this.indexXZ((int)x, (int)z)] = biomeAccess.method_22393((class_2338)pos.method_10103(x + this.baseX, level + this.baseY, z + this.baseZ));
            }
        }
        return biomeData;
    }

    private int[] gatherColorsXZ(class_6539 resolver, int y) {
        class_6880<class_1959>[] biomeData = this.getBiomeData(y);
        int[] colorData = new int[this.sizeHorizontal * this.sizeHorizontal];
        for (int x = 0; x < this.sizeHorizontal; ++x) {
            for (int z = 0; z < this.sizeHorizontal; ++z) {
                int index = this.indexXZ(x, z);
                colorData[index] = resolver.getColor((class_1959)biomeData[index].comp_349(), (double)(x + this.baseX), (double)(z + this.baseZ));
            }
        }
        BoxBlur.blur(colorData, this.sizeHorizontal, this.sizeHorizontal, this.blurHorizontal);
        return colorData;
    }

    private class_6880<class_1959>[] getBiomeData(int y) {
        class_6880<class_1959>[] biomes = this.biomes[y];
        if (biomes == null) {
            biomes = this.gatherBiomes(y);
            this.biomes[y] = biomes;
        }
        return biomes;
    }

    private int indexXZ(int x, int z) {
        return x * this.sizeHorizontal + z;
    }
}

