/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.block.hopper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.jellysquid.mods.lithium.api.inventory.LithiumInventory;
import me.jellysquid.mods.lithium.common.block.entity.SleepingBlockEntity;
import me.jellysquid.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeListener;
import me.jellysquid.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import me.jellysquid.mods.lithium.common.block.entity.inventory_comparator_tracking.ComparatorTracker;
import me.jellysquid.mods.lithium.common.compat.fabric_transfer_api_v1.FabricTransferApiCompat;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.NearbyEntityMovementListener;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.SectionedInventoryEntityMovementTracker;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.SectionedItemEntityMovementTracker;
import me.jellysquid.mods.lithium.common.hopper.HopperCachingState;
import me.jellysquid.mods.lithium.common.hopper.HopperHelper;
import me.jellysquid.mods.lithium.common.hopper.InventoryHelper;
import me.jellysquid.mods.lithium.common.hopper.LithiumStackList;
import me.jellysquid.mods.lithium.common.hopper.UpdateReceiver;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2615;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_2614.class}, priority=950)
public abstract class HopperBlockEntityMixin
extends class_2586
implements class_2615,
UpdateReceiver,
LithiumInventory,
InventoryChangeListener,
NearbyEntityMovementListener {
    @Shadow
    private long field_12022;
    private long myModCountAtLastInsert;
    private long myModCountAtLastExtract;
    private long myModCountAtLastItemCollect;
    private HopperCachingState.BlockInventory insertionMode = HopperCachingState.BlockInventory.UNKNOWN;
    private HopperCachingState.BlockInventory extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
    @Nullable
    private class_1263 insertBlockInventory;
    @Nullable
    private class_1263 extractBlockInventory;
    @Nullable
    private LithiumInventory insertInventory;
    @Nullable
    private LithiumInventory extractInventory;
    @Nullable
    private LithiumStackList insertStackList;
    @Nullable
    private LithiumStackList extractStackList;
    private long insertStackListModCount;
    private long extractStackListModCount;
    private SectionedItemEntityMovementTracker<class_1542> collectItemEntityTracker;
    private boolean collectItemEntityTrackerWasEmpty;
    private class_238[] collectItemEntityBoxes;
    private long collectItemEntityAttemptTime;
    private SectionedInventoryEntityMovementTracker<class_1263> extractInventoryEntityTracker;
    private class_238 extractInventoryEntityBox;
    private long extractInventoryEntityFailedSearchTime;
    private SectionedInventoryEntityMovementTracker<class_1263> insertInventoryEntityTracker;
    private class_238 insertInventoryEntityBox;
    private long insertInventoryEntityFailedSearchTime;
    private boolean shouldCheckSleep;

    public HopperBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Shadow
    @Nullable
    private static native class_1263 method_11248(class_1937 var0, class_2615 var1);

    @Shadow
    protected abstract boolean method_11242();

    @Shadow
    private static native boolean method_11252(class_1263 var0, class_1799 var1, int var2, class_2350 var3);

    @Redirect(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;getInputInventory(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Lnet/minecraft/inventory/Inventory;"))
    private static class_1263 getExtractInventory(class_1937 world, class_2615 hopper) {
        if (!(hopper instanceof HopperBlockEntityMixin)) {
            return HopperBlockEntityMixin.method_11248(world, hopper);
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        class_1263 blockInventory = hopperBlockEntity.getExtractBlockInventory(world);
        if (blockInventory != null) {
            return blockInventory;
        }
        if (hopperBlockEntity.extractInventoryEntityTracker == null) {
            hopperBlockEntity.initExtractInventoryTracker(world);
        }
        if (hopperBlockEntity.extractInventoryEntityTracker.isUnchangedSince(hopperBlockEntity.extractInventoryEntityFailedSearchTime)) {
            hopperBlockEntity.extractInventoryEntityFailedSearchTime = hopperBlockEntity.field_12022;
            return null;
        }
        hopperBlockEntity.extractInventoryEntityFailedSearchTime = Long.MIN_VALUE;
        hopperBlockEntity.shouldCheckSleep = false;
        List<class_1263> inventoryEntities = hopperBlockEntity.extractInventoryEntityTracker.getEntities(hopperBlockEntity.extractInventoryEntityBox);
        if (inventoryEntities.isEmpty()) {
            hopperBlockEntity.extractInventoryEntityFailedSearchTime = hopperBlockEntity.field_12022;
            return null;
        }
        class_1263 inventory = inventoryEntities.get(world.field_9229.method_43048(inventoryEntities.size()));
        if (inventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)inventory;
            LithiumStackList extractInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            if (inventory != hopperBlockEntity.extractInventory || hopperBlockEntity.extractStackList != extractInventoryStackList) {
                hopperBlockEntity.extractInventory = optimizedInventory;
                hopperBlockEntity.extractStackList = extractInventoryStackList;
                hopperBlockEntity.extractStackListModCount = hopperBlockEntity.extractStackList.getModCount() - 1L;
            }
        }
        return inventory;
    }

    @Inject(cancellable=true, method={"insert(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/inventory/Inventory;)Z"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/block/entity/HopperBlockEntity;isInventoryFull(Lnet/minecraft/inventory/Inventory;Lnet/minecraft/util/math/Direction;)Z")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void lithiumInsert(class_1937 world, class_2338 pos, class_2680 hopperState, class_1263 hopper, CallbackInfoReturnable<Boolean> cir, class_1263 insertInventory, class_2350 direction) {
        boolean insertInventoryWasEmptyHopperNotDisabled;
        if (insertInventory == null || !(hopper instanceof class_2614)) {
            return;
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        LithiumStackList hopperStackList = InventoryHelper.getLithiumStackList(hopperBlockEntity);
        if (hopperBlockEntity.insertInventory == insertInventory && hopperStackList.getModCount() == hopperBlockEntity.myModCountAtLastInsert && hopperBlockEntity.insertStackList != null && hopperBlockEntity.insertStackList.getModCount() == hopperBlockEntity.insertStackListModCount) {
            cir.setReturnValue((Object)false);
            return;
        }
        boolean bl = insertInventoryWasEmptyHopperNotDisabled = insertInventory instanceof HopperBlockEntityMixin && !((HopperBlockEntityMixin)insertInventory).method_11242() && hopperBlockEntity.insertStackList != null && hopperBlockEntity.insertStackList.getOccupiedSlots() == 0;
        if (hopperBlockEntity.insertInventory != insertInventory || hopperBlockEntity.insertStackList.getFullSlots() != hopperBlockEntity.insertStackList.size()) {
            class_2350 fromDirection = ((class_2350)hopperState.method_11654((class_2769)class_2377.field_11129)).method_10153();
            int size = hopperStackList.size();
            for (int i = 0; i < size; ++i) {
                boolean transferSuccess;
                class_1799 transferStack = (class_1799)hopperStackList.get(i);
                if (transferStack.method_7960() || !(transferSuccess = HopperHelper.tryMoveSingleItem(insertInventory, transferStack, fromDirection))) continue;
                if (insertInventoryWasEmptyHopperNotDisabled) {
                    HopperBlockEntityMixin receivingHopper = (HopperBlockEntityMixin)insertInventory;
                    int k = 8;
                    if (receivingHopper.field_12022 >= hopperBlockEntity.field_12022) {
                        k = 7;
                    }
                    receivingHopper.method_11238(k);
                }
                insertInventory.method_5431();
                cir.setReturnValue((Object)true);
                return;
            }
        }
        hopperBlockEntity.myModCountAtLastInsert = hopperStackList.getModCount();
        if (hopperBlockEntity.insertStackList != null) {
            hopperBlockEntity.insertStackListModCount = hopperBlockEntity.insertStackList.getModCount();
        }
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at={@At(value="FIELD", target="Lnet/minecraft/util/math/Direction;DOWN:Lnet/minecraft/util/math/Direction;", shift=At.Shift.AFTER)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void lithiumExtract(class_1937 world, class_2615 to, CallbackInfoReturnable<Boolean> cir, class_1263 from) {
        if (!(to instanceof HopperBlockEntityMixin)) {
            return;
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)to;
        if (from != hopperBlockEntity.extractInventory || hopperBlockEntity.extractStackList == null) {
            return;
        }
        LithiumStackList hopperStackList = InventoryHelper.getLithiumStackList(hopperBlockEntity);
        LithiumStackList fromStackList = hopperBlockEntity.extractStackList;
        if (hopperStackList.getModCount() == hopperBlockEntity.myModCountAtLastExtract && fromStackList.getModCount() == hopperBlockEntity.extractStackListModCount) {
            ComparatorTracker comparatorTracker;
            if (!(from instanceof ComparatorTracker) || (comparatorTracker = (ComparatorTracker)from).hasAnyComparatorNearby()) {
                fromStackList.runComparatorUpdatePatternOnFailedExtract(fromStackList, from);
            }
            cir.setReturnValue((Object)false);
            return;
        }
        int[] availableSlots = from instanceof class_1278 ? ((class_1278)from).method_5494(class_2350.field_11033) : null;
        int fromSize = availableSlots != null ? availableSlots.length : from.method_5439();
        for (int i = 0; i < fromSize; ++i) {
            int fromSlot = availableSlots != null ? availableSlots[i] : i;
            class_1799 itemStack = (class_1799)fromStackList.get(fromSlot);
            if (itemStack.method_7960() || !HopperBlockEntityMixin.method_11252(from, itemStack, fromSlot, class_2350.field_11033)) continue;
            class_1799 takenItem = from.method_5434(fromSlot, 1);
            assert (!takenItem.method_7960());
            boolean transferSuccess = HopperHelper.tryMoveSingleItem((class_1263)to, takenItem, null);
            if (transferSuccess) {
                to.method_5431();
                from.method_5431();
                cir.setReturnValue((Object)true);
                return;
            }
            class_1799 restoredStack = (class_1799)fromStackList.get(fromSlot);
            if (restoredStack.method_7960()) {
                restoredStack = takenItem;
            } else {
                restoredStack.method_7933(1);
            }
            from.method_5447(fromSlot, restoredStack);
        }
        hopperBlockEntity.myModCountAtLastExtract = hopperStackList.getModCount();
        if (fromStackList != null) {
            hopperBlockEntity.extractStackListModCount = fromStackList.getModCount();
        }
        cir.setReturnValue((Object)false);
    }

    @Redirect(method={"insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;isFull()Z"))
    private static boolean lithiumHopperIsFull(class_2614 hopperBlockEntity) {
        LithiumStackList lithiumStackList = InventoryHelper.getLithiumStackList((HopperBlockEntityMixin)hopperBlockEntity);
        return lithiumStackList.getFullSlots() == lithiumStackList.size();
    }

    @Redirect(method={"insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;isEmpty()Z"))
    private static boolean lithiumHopperIsEmpty(class_2614 hopperBlockEntity) {
        LithiumStackList lithiumStackList = InventoryHelper.getLithiumStackList((HopperBlockEntityMixin)hopperBlockEntity);
        return lithiumStackList.getOccupiedSlots() == 0;
    }

    @Shadow
    protected abstract void method_11238(int var1);

    @Shadow
    protected abstract boolean method_11239();

    @Override
    public void onNeighborUpdate(boolean above) {
        if (above) {
            if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
                this.invalidateBlockExtractionData();
            }
        } else if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            this.invalidateBlockInsertionData();
        }
    }

    @Redirect(method={"insert(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/inventory/Inventory;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;getOutputInventory(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Lnet/minecraft/inventory/Inventory;"))
    private static class_1263 nullify(class_1937 world, class_2338 pos, class_2680 state) {
        return null;
    }

    @ModifyVariable(method={"insert(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/inventory/Inventory;)Z"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/block/entity/HopperBlockEntity;getOutputInventory(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Lnet/minecraft/inventory/Inventory;"), ordinal=1)
    private static class_1263 getLithiumOutputInventory(class_1263 inventory, class_1937 world, class_2338 pos, class_2680 hopperState, class_1263 hopper) {
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        return hopperBlockEntity.getInsertInventory(world, hopperState);
    }

    @Redirect(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;getInputItemEntities(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Ljava/util/List;"))
    private static List<class_1542> lithiumGetInputItemEntities(class_1937 world, class_2615 hopper) {
        if (!(hopper instanceof HopperBlockEntityMixin)) {
            return class_2614.method_11237((class_1937)world, (class_2615)hopper);
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        if (hopperBlockEntity.collectItemEntityTracker == null) {
            hopperBlockEntity.initCollectItemEntityTracker();
        }
        long modCount = InventoryHelper.getLithiumStackList(hopperBlockEntity).getModCount();
        if ((hopperBlockEntity.collectItemEntityTrackerWasEmpty || hopperBlockEntity.myModCountAtLastItemCollect == modCount) && hopperBlockEntity.collectItemEntityTracker.isUnchangedSince(hopperBlockEntity.collectItemEntityAttemptTime)) {
            hopperBlockEntity.collectItemEntityAttemptTime = hopperBlockEntity.field_12022;
            return Collections.emptyList();
        }
        hopperBlockEntity.myModCountAtLastItemCollect = modCount;
        hopperBlockEntity.shouldCheckSleep = false;
        List<class_1542> itemEntities = hopperBlockEntity.collectItemEntityTracker.getEntities(hopperBlockEntity.collectItemEntityBoxes);
        hopperBlockEntity.collectItemEntityAttemptTime = hopperBlockEntity.field_12022;
        hopperBlockEntity.collectItemEntityTrackerWasEmpty = itemEntities.isEmpty();
        return itemEntities;
    }

    private void cacheInsertBlockInventory(class_1263 insertInventory) {
        assert (!(insertInventory instanceof class_1297));
        if (insertInventory instanceof class_2586 || insertInventory instanceof class_1258) {
            this.insertBlockInventory = insertInventory;
            if (insertInventory instanceof InventoryChangeTracker) {
                this.insertionMode = HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY;
                ((InventoryChangeTracker)insertInventory).listenForMajorInventoryChanges(this);
            } else {
                this.insertionMode = HopperCachingState.BlockInventory.BLOCK_ENTITY;
            }
        } else if (insertInventory == null) {
            this.insertBlockInventory = null;
            this.insertionMode = HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY;
        } else {
            this.insertBlockInventory = insertInventory;
            this.insertionMode = HopperCachingState.BlockInventory.BLOCK_STATE;
        }
        if (insertInventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)insertInventory;
            this.cacheInsertLithiumInventory(optimizedInventory);
        } else {
            this.insertInventory = null;
            this.insertStackList = null;
            this.insertStackListModCount = 0L;
        }
    }

    private void cacheInsertLithiumInventory(LithiumInventory optimizedInventory) {
        LithiumStackList insertInventoryStackList;
        this.insertInventory = optimizedInventory;
        this.insertStackList = insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
        this.insertStackListModCount = insertInventoryStackList.getModCount() - 1L;
    }

    @Overwrite
    private static boolean method_11257(class_1263 inv, class_2350 side) {
        int[] availableSlots = inv instanceof class_1278 ? ((class_1278)inv).method_5494(side) : null;
        int fromSize = availableSlots != null ? availableSlots.length : inv.method_5439();
        for (int i = 0; i < fromSize; ++i) {
            int slot;
            int n = slot = availableSlots != null ? availableSlots[i] : i;
            if (inv.method_5438(slot).method_7960()) continue;
            return false;
        }
        return true;
    }

    private void cacheExtractBlockInventory(class_1263 extractInventory) {
        assert (!(extractInventory instanceof class_1297));
        if (extractInventory instanceof class_2586 || extractInventory instanceof class_1258) {
            this.extractBlockInventory = extractInventory;
            if (extractInventory instanceof InventoryChangeTracker) {
                this.extractionMode = HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY;
                ((InventoryChangeTracker)extractInventory).listenForMajorInventoryChanges(this);
            } else {
                this.extractionMode = HopperCachingState.BlockInventory.BLOCK_ENTITY;
            }
        } else if (extractInventory == null) {
            this.extractBlockInventory = null;
            this.extractionMode = HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY;
        } else {
            this.extractBlockInventory = extractInventory;
            this.extractionMode = HopperCachingState.BlockInventory.BLOCK_STATE;
        }
        if (extractInventory instanceof LithiumInventory) {
            LithiumStackList extractInventoryStackList;
            LithiumInventory optimizedInventory;
            this.extractInventory = optimizedInventory = (LithiumInventory)extractInventory;
            this.extractStackList = extractInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            this.extractStackListModCount = extractInventoryStackList.getModCount() - 1L;
        } else {
            this.extractInventory = null;
            this.extractStackList = null;
            this.extractStackListModCount = 0L;
        }
    }

    public class_1263 getExtractBlockInventory(class_1937 world) {
        class_1263 blockInventory = this.extractBlockInventory;
        if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) {
            return null;
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            return blockInventory;
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
            return blockInventory;
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY) {
            class_2586 blockEntity = (class_2586)Objects.requireNonNull(blockInventory);
            class_2338 pos = blockEntity.method_11016();
            class_2338 thisPos = this.method_11016();
            if (!blockEntity.method_11015() && pos.method_10263() == thisPos.method_10263() && pos.method_10264() == thisPos.method_10264() + 1 && pos.method_10260() == thisPos.method_10260()) {
                LithiumInventory optimizedInventory = this.extractInventory;
                if (optimizedInventory != null) {
                    LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
                    if (insertInventoryStackList == this.extractStackList) {
                        return optimizedInventory;
                    }
                    this.invalidateBlockExtractionData();
                } else {
                    return blockInventory;
                }
            }
        }
        blockInventory = HopperHelper.vanillaGetBlockInventory(world, this.method_11016().method_10084());
        this.cacheExtractBlockInventory(blockInventory);
        return blockInventory;
    }

    public class_1263 getInsertBlockInventory(class_1937 world, class_2680 hopperState) {
        class_1263 blockInventory = this.insertBlockInventory;
        if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) {
            return null;
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            return blockInventory;
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
            return blockInventory;
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY) {
            class_2586 blockEntity = (class_2586)Objects.requireNonNull(blockInventory);
            class_2338 pos = blockEntity.method_11016();
            class_2350 direction = (class_2350)hopperState.method_11654((class_2769)class_2377.field_11129);
            class_2338 transferPos = this.method_11016().method_10093(direction);
            if (!blockEntity.method_11015() && pos.equals((Object)transferPos)) {
                LithiumInventory optimizedInventory = this.insertInventory;
                if (optimizedInventory != null) {
                    LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
                    if (insertInventoryStackList == this.insertStackList) {
                        return optimizedInventory;
                    }
                    this.invalidateBlockInsertionData();
                } else {
                    return blockInventory;
                }
            }
        }
        class_2350 direction = (class_2350)hopperState.method_11654((class_2769)class_2377.field_11129);
        blockInventory = HopperHelper.vanillaGetBlockInventory(world, this.method_11016().method_10093(direction));
        this.cacheInsertBlockInventory(blockInventory);
        return blockInventory;
    }

    public class_1263 getInsertInventory(class_1937 world, class_2680 hopperState) {
        class_1263 blockInventory = this.getInsertBlockInventory(world, hopperState);
        if (blockInventory != null) {
            return blockInventory;
        }
        if (this.insertInventoryEntityTracker == null) {
            this.initInsertInventoryTracker(world, hopperState);
        }
        if (this.insertInventoryEntityTracker.isUnchangedSince(this.insertInventoryEntityFailedSearchTime)) {
            this.insertInventoryEntityFailedSearchTime = this.field_12022;
            return null;
        }
        this.insertInventoryEntityFailedSearchTime = Long.MIN_VALUE;
        this.shouldCheckSleep = false;
        List<class_1263> inventoryEntities = this.insertInventoryEntityTracker.getEntities(this.insertInventoryEntityBox);
        if (inventoryEntities.isEmpty()) {
            this.insertInventoryEntityFailedSearchTime = this.field_12022;
            return null;
        }
        class_1263 inventory = inventoryEntities.get(world.field_9229.method_43048(inventoryEntities.size()));
        if (inventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)inventory;
            LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            if (inventory != this.insertInventory || this.insertStackList != insertInventoryStackList) {
                this.cacheInsertLithiumInventory(optimizedInventory);
            }
        }
        return inventory;
    }

    private void initCollectItemEntityTracker() {
        assert (this.field_11863 instanceof class_3218);
        ArrayList<class_238> list = new ArrayList<class_238>();
        class_238 encompassingBox = null;
        for (class_238 box : HopperHelper.getHopperPickupVolumeBoxes(this)) {
            class_238 offsetBox = box.method_989((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
            list.add(offsetBox);
            encompassingBox = encompassingBox == null ? offsetBox : encompassingBox.method_991(offsetBox);
        }
        list.add(encompassingBox);
        this.collectItemEntityBoxes = list.toArray(new class_238[0]);
        this.collectItemEntityTracker = SectionedItemEntityMovementTracker.registerAt((class_3218)this.field_11863, encompassingBox, class_1542.class);
        this.collectItemEntityAttemptTime = Long.MIN_VALUE;
    }

    private void initExtractInventoryTracker(class_1937 world) {
        assert (world instanceof class_3218);
        class_2338 pos = this.field_11867.method_10093(class_2350.field_11036);
        this.extractInventoryEntityBox = new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + 1));
        this.extractInventoryEntityTracker = SectionedInventoryEntityMovementTracker.registerAt((class_3218)this.field_11863, this.extractInventoryEntityBox, class_1263.class);
        this.extractInventoryEntityFailedSearchTime = Long.MIN_VALUE;
    }

    private void initInsertInventoryTracker(class_1937 world, class_2680 hopperState) {
        assert (world instanceof class_3218);
        class_2350 direction = (class_2350)hopperState.method_11654((class_2769)class_2377.field_11129);
        class_2338 pos = this.field_11867.method_10093(direction);
        this.insertInventoryEntityBox = new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + 1));
        this.insertInventoryEntityTracker = SectionedInventoryEntityMovementTracker.registerAt((class_3218)this.field_11863, this.insertInventoryEntityBox, class_1263.class);
        this.insertInventoryEntityFailedSearchTime = Long.MIN_VALUE;
    }

    public void method_31664(class_2680 state) {
        class_2680 cachedState = this.method_11010();
        super.method_31664(state);
        if (state.method_11654((class_2769)class_2377.field_11129) != cachedState.method_11654((class_2769)class_2377.field_11129)) {
            this.invalidateCachedData();
        }
    }

    private void invalidateCachedData() {
        this.shouldCheckSleep = false;
        this.invalidateInsertionData();
        this.invalidateExtractionData();
    }

    private void invalidateInsertionData() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.insertInventoryEntityTracker != null) {
                this.insertInventoryEntityTracker.unRegister(serverWorld);
                this.insertInventoryEntityTracker = null;
                this.insertInventoryEntityBox = null;
                this.insertInventoryEntityFailedSearchTime = 0L;
            }
        }
        this.invalidateBlockInsertionData();
    }

    private void invalidateBlockInsertionData() {
        if (this.insertionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
            assert (this.insertBlockInventory != null);
            ((InventoryChangeTracker)this.insertBlockInventory).stopListenForMajorInventoryChanges(this);
        }
        this.insertionMode = HopperCachingState.BlockInventory.UNKNOWN;
        this.insertBlockInventory = null;
        this.insertInventory = null;
        this.insertStackList = null;
        this.insertStackListModCount = 0L;
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }

    private void invalidateExtractionData() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.extractInventoryEntityTracker != null) {
                this.extractInventoryEntityTracker.unRegister(serverWorld);
                this.extractInventoryEntityTracker = null;
                this.extractInventoryEntityBox = null;
                this.extractInventoryEntityFailedSearchTime = 0L;
            }
            if (this.collectItemEntityTracker != null) {
                this.collectItemEntityTracker.unRegister(serverWorld);
                this.collectItemEntityTracker = null;
                this.collectItemEntityBoxes = null;
                this.collectItemEntityTrackerWasEmpty = false;
            }
        }
        this.invalidateBlockExtractionData();
    }

    private void invalidateBlockExtractionData() {
        if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
            assert (this.extractBlockInventory != null);
            ((InventoryChangeTracker)this.extractBlockInventory).stopListenForMajorInventoryChanges(this);
        }
        this.extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
        this.extractBlockInventory = null;
        this.extractInventory = null;
        this.extractStackList = null;
        this.extractStackListModCount = 0L;
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }

    @Inject(method={"serverTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z", shift=At.Shift.AFTER)})
    private static void checkSleepingConditions(class_1937 world, class_2338 pos, class_2680 state, class_2614 blockEntity, CallbackInfo ci) {
        ((HopperBlockEntityMixin)blockEntity).checkSleepingConditions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkSleepingConditions() {
        class_1263 blockInventory;
        if (this.method_11239()) {
            return;
        }
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (!(hopperBlockEntityMixin instanceof SleepingBlockEntity)) return;
        SleepingBlockEntity thisSleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
        if (thisSleepingBlockEntity.isSleeping()) {
            return;
        }
        if (!this.shouldCheckSleep) {
            this.shouldCheckSleep = true;
            return;
        }
        HopperBlockEntityMixin hopperBlockEntityMixin2 = this;
        if (!(hopperBlockEntityMixin2 instanceof InventoryChangeTracker)) return;
        InventoryChangeTracker thisTracker = (InventoryChangeTracker)((Object)hopperBlockEntityMixin2);
        boolean listenToExtractTracker = false;
        boolean listenToInsertTracker = false;
        boolean listenToExtractEntities = false;
        boolean listenToInsertEntities = false;
        LithiumStackList thisStackList = InventoryHelper.getLithiumStackList(this);
        if (this.extractionMode != HopperCachingState.BlockInventory.BLOCK_STATE && thisStackList.getFullSlots() != thisStackList.size()) {
            if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
                ComparatorTracker comparatorTracker;
                blockInventory = this.extractBlockInventory;
                if (this.extractStackList == null || !(blockInventory instanceof InventoryChangeTracker)) return;
                if (this.extractStackList.maybeSendsComparatorUpdatesOnFailedExtract() && (!(blockInventory instanceof ComparatorTracker) || (comparatorTracker = (ComparatorTracker)blockInventory).hasAnyComparatorNearby())) return;
                listenToExtractTracker = true;
            } else {
                if (this.extractionMode != HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) return;
                if (FabricTransferApiCompat.FABRIC_TRANSFER_API_V_1_PRESENT && FabricTransferApiCompat.canHopperInteractWithApiInventory((class_2614)this, this.method_11010(), true)) {
                    return;
                }
                listenToExtractEntities = true;
            }
        }
        if (this.insertionMode != HopperCachingState.BlockInventory.BLOCK_STATE && 0 < thisStackList.getOccupiedSlots()) {
            if (this.insertionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
                blockInventory = this.insertBlockInventory;
                if (this.insertStackList == null || !(blockInventory instanceof InventoryChangeTracker)) return;
                listenToInsertTracker = true;
            } else {
                if (this.insertionMode != HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) return;
                if (FabricTransferApiCompat.FABRIC_TRANSFER_API_V_1_PRESENT && FabricTransferApiCompat.canHopperInteractWithApiInventory((class_2614)this, this.method_11010(), false)) {
                    return;
                }
                listenToInsertEntities = true;
            }
        }
        if (listenToExtractTracker) {
            ((InventoryChangeTracker)this.extractBlockInventory).listenForContentChangesOnce(this.extractStackList, this);
        }
        if (listenToInsertTracker) {
            ((InventoryChangeTracker)this.insertBlockInventory).listenForContentChangesOnce(this.insertStackList, this);
        }
        if (listenToInsertEntities) {
            if (this.insertInventoryEntityTracker == null) {
                this.initInsertInventoryTracker(this.field_11863, this.method_11010());
            }
            this.insertInventoryEntityTracker.listenToEntityMovementOnce(this);
        }
        if (listenToExtractEntities) {
            if (this.extractInventoryEntityTracker == null) {
                this.initExtractInventoryTracker(this.field_11863);
            }
            this.extractInventoryEntityTracker.listenToEntityMovementOnce(this);
            if (this.collectItemEntityTracker == null) {
                this.initCollectItemEntityTracker();
            }
            this.collectItemEntityTracker.listenToEntityMovementOnce(this);
        }
        thisTracker.listenForContentChangesOnce(thisStackList, this);
        thisSleepingBlockEntity.startSleeping();
    }

    @Override
    public void handleStackListReplaced(class_1263 inventory) {
        if (this instanceof SleepingBlockEntity) {
            ((SleepingBlockEntity)((Object)this)).wakeUpNow();
        }
        if (inventory == this.insertBlockInventory) {
            this.invalidateBlockInsertionData();
        }
        if (inventory == this.extractBlockInventory) {
            this.invalidateBlockExtractionData();
        }
        if (inventory == this) {
            this.invalidateCachedData();
        }
    }

    @Override
    public void handleInventoryContentModified(class_1263 inventory) {
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }

    @Override
    public void handleInventoryRemoved(class_1263 inventory) {
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
        if (inventory == this.insertBlockInventory) {
            this.invalidateBlockInsertionData();
        }
        if (inventory == this.extractBlockInventory) {
            this.invalidateBlockExtractionData();
        }
        if (inventory == this) {
            this.invalidateCachedData();
        }
    }

    @Override
    public void handleComparatorAdded(class_1263 inventory) {
        HopperBlockEntityMixin hopperBlockEntityMixin;
        if (inventory == this.extractBlockInventory && (hopperBlockEntityMixin = this) instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }

    @Override
    public void handleEntityMovement(Class<?> category) {
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }
}

