/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.text.DecimalFormat;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.component.ArmorComponent;
import mcp.mobius.waila.api.component.HealthComponent;
import mcp.mobius.waila.api.component.SpacingComponent;
import mcp.mobius.waila.api.component.TextureComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public enum EntityAttributesProvider implements IEntityComponentProvider,
IServerDataProvider<class_1297>
{
    INSTANCE;

    private static final DecimalFormat DECIMAL;

    private int addSpacing(ITooltipLine line, int i) {
        if (i > 0) {
            line.with(new SpacingComponent(3, 0));
            return i - 1;
        }
        return 0;
    }

    private void addHealth(ITooltipLine line, class_1309 entity, class_2487 data, boolean showAbsorption) {
        class_5250 component = class_2561.method_43470((String)DECIMAL.format(entity.method_6032()));
        if (showAbsorption && data.method_10545("abs")) {
            component.method_10852((class_2561)class_2561.method_43470((String)("+" + DECIMAL.format(data.method_10583("abs")))).method_27692(class_124.field_1065));
        }
        line.with(new TextureComponent(class_332.field_22737, 8, 8, 52, 0, 9, 9, 256, 256)).with((class_2561)component.method_27693("/" + DECIMAL.format(entity.method_6063())).method_27692(class_124.field_1061));
    }

    private void addArmor(ITooltipLine line, class_1309 entity) {
        line.with(new TextureComponent(class_332.field_22737, 8, 8, 34, 9, 9, 9, 256, 256)).with((class_2561)class_2561.method_43470((String)String.valueOf(entity.method_6096())));
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Object t = accessor.getEntity();
        if (!(t instanceof class_1309)) {
            return;
        }
        class_1309 entity = (class_1309)t;
        boolean compact = config.getBoolean(Options.ATTRIBUTE_COMPACT);
        boolean showHealth = config.getBoolean(Options.ATTRIBUTE_HEALTH);
        boolean showAbsorption = config.getBoolean(Options.ATTRIBUTE_ABSORPTION);
        boolean showArmor = config.getBoolean(Options.ATTRIBUTE_ARMOR) && entity.method_6096() > 0;
        class_2487 data = accessor.getServerData();
        if (compact) {
            ITooltipLine line = tooltip.addLine();
            int i = 0;
            if (showHealth) {
                i = this.addSpacing(line, i);
                this.addHealth(line, entity, data, showAbsorption);
                ++i;
            }
            if (showArmor) {
                i = this.addSpacing(line, i);
                this.addArmor(line, entity);
                ++i;
            }
        } else {
            int maxPerLine = config.getInt(Options.ATTRIBUTE_ICON_PER_LINE);
            if (showHealth) {
                float absorption;
                float f = absorption = data.method_10545("abs") ? data.method_10583("abs") : 0.0f;
                if (entity.method_6063() + absorption > (float)config.getInt(Options.ATTRIBUTE_LONG_HEALTH_MAX)) {
                    this.addHealth(tooltip.addLine(), entity, data, showAbsorption);
                } else {
                    tooltip.addLine(new HealthComponent(entity.method_6032(), entity.method_6063(), maxPerLine, false));
                    if (showAbsorption && absorption > 0.0f) {
                        tooltip.addLine(new HealthComponent(absorption, 0.0f, maxPerLine, true));
                    }
                }
            }
            if (showArmor) {
                if (entity.method_6096() > config.getInt(Options.ATTRIBUTE_LONG_ARMOR_MAX)) {
                    this.addArmor(tooltip.addLine(), entity);
                } else {
                    tooltip.addLine(new ArmorComponent(entity.method_6096(), maxPerLine));
                }
            }
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.ATTRIBUTE_ENTITY_POSITION)) {
            class_243 pos = accessor.getEntity().method_19538();
            tooltip.addLine((class_2561)class_2561.method_43470((String)("(" + DECIMAL.format(pos.field_1352) + ", " + DECIMAL.format(pos.field_1351) + ", " + DECIMAL.format(pos.field_1350) + ")")));
        }
    }

    @Override
    public void appendServerData(class_2487 data, IServerAccessor<class_1297> accessor, IPluginConfig config) {
        class_1297 class_12972 = accessor.getTarget();
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            if (config.getBoolean(Options.ATTRIBUTE_ABSORPTION) && living.method_6067() > 0.0f) {
                data.method_10548("abs", living.method_6067());
            }
        }
    }

    static {
        DECIMAL = new DecimalFormat("0.##");
    }
}

