/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.fabric;

import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.plugin.PluginLoader;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class FabricPluginLoader
extends PluginLoader {
    @Override
    protected void gatherPlugins() {
        Object2ObjectOpenHashMap pluginMap = new Object2ObjectOpenHashMap();
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            modContainer.findPath("waila_plugins.json").ifPresent(path -> this.readPluginsJson(mod.getMetadata().getId(), (Path)path));
            ModMetadata data = modContainer.getMetadata();
            if (!data.containsCustomValue("waila:plugins")) continue;
            CustomValue val = data.getCustomValue("waila:plugins");
            if (val.getType() == CustomValue.CvType.OBJECT) {
                pluginMap.put(modContainer, new CustomValue.CvObject[]{val.getAsObject()});
                continue;
            }
            if (val.getType() == CustomValue.CvType.ARRAY) {
                pluginMap.put(modContainer, (CustomValue.CvObject[])Streams.stream((Iterable)val.getAsArray()).map(CustomValue::getAsObject).toArray(CustomValue.CvObject[]::new));
                continue;
            }
            Waila.LOGGER.error("Plugin data provided by {} must be an object or array of objects.", (Object)data.getId());
        }
        for (Map.Entry entry : pluginMap.entrySet()) {
            CustomValue.CvObject[] plugins;
            ModContainer mod = (ModContainer)entry.getKey();
            block12: for (CustomValue.CvObject plugin : plugins = (CustomValue.CvObject[])entry.getValue()) {
                IPluginInfo.Side side;
                String sideStr;
                ArrayList<String> requiredDeps = new ArrayList<String>();
                if (plugin.containsKey("required")) {
                    CustomValue required = plugin.get("required");
                    if (required.getType() == CustomValue.CvType.STRING) {
                        if (!FabricLoader.getInstance().isModLoaded(required.getAsString())) continue;
                        requiredDeps.add(required.getAsString());
                    }
                    if (required.getType() == CustomValue.CvType.ARRAY) {
                        for (CustomValue element : required.getAsArray()) {
                            if (element.getType() != CustomValue.CvType.STRING) continue;
                            if (!FabricLoader.getInstance().isModLoaded(element.getAsString())) continue block12;
                            requiredDeps.add(element.getAsString());
                        }
                    }
                }
                String id = plugin.get("id").getAsString();
                String initializer = plugin.get("initializer").getAsString();
                switch (sideStr = plugin.containsKey("environment") ? plugin.get("environment").getAsString() : "both") {
                    case "client": {
                        side = IPluginInfo.Side.CLIENT;
                        break;
                    }
                    case "server": {
                        side = IPluginInfo.Side.SERVER;
                        break;
                    }
                    case "both": {
                        side = IPluginInfo.Side.BOTH;
                        break;
                    }
                    default: {
                        Waila.LOGGER.error("Environment for plugin {} is not valid, must be one of [client, server, both].", (Object)id);
                        continue block12;
                    }
                }
                if (side == IPluginInfo.Side.CLIENT && FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT || side == IPluginInfo.Side.SERVER && FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER) continue;
                PluginInfo.register(mod.getMetadata().getId(), id, side, initializer, requiredDeps, true);
            }
        }
    }
}

