/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.DataAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.hud.TooltipHandler;
import mcp.mobius.waila.gui.screen.HomeScreen;
import mcp.mobius.waila.integration.IRecipeAction;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.service.IClientService;
import net.minecraft.class_1799;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public abstract class WailaClient {
    public static class_304 keyOpenConfig;
    public static class_304 keyShowOverlay;
    public static class_304 keyToggleLiquid;
    public static class_304 keyShowRecipeInput;
    public static class_304 keyShowRecipeOutput;
    public static boolean showComponentBounds;
    @Nullable
    private static IRecipeAction recipeAction;

    public static void setRecipeAction(IRecipeAction action) {
        if (recipeAction == null) {
            Waila.LOGGER.info("Show recipe action set for " + action.getModName());
        } else if (!recipeAction.getModName().equals(action.getModName())) {
            Waila.LOGGER.warn("Show recipe action is already set for " + recipeAction.getModName());
            Waila.LOGGER.warn("Replaced it with one for " + action.getModName());
        }
        recipeAction = action;
    }

    protected static List<class_304> registerKeyBinds() {
        keyOpenConfig = WailaClient.createKeyBind("key.waila.config");
        keyShowOverlay = WailaClient.createKeyBind("key.waila.show_overlay");
        keyToggleLiquid = WailaClient.createKeyBind("key.waila.toggle_liquid");
        keyShowRecipeInput = WailaClient.createKeyBind("key.waila.show_recipe_input");
        keyShowRecipeOutput = WailaClient.createKeyBind("key.waila.show_recipe_output");
        return List.of(keyOpenConfig, keyShowOverlay, keyToggleLiquid, keyShowRecipeInput, keyShowRecipeOutput);
    }

    protected static void onClientTick() {
        class_310 client = class_310.method_1551();
        WailaConfig config = Waila.CONFIG.get();
        TooltipHandler.tick();
        while (keyOpenConfig.method_1436()) {
            client.method_1507((class_437)new HomeScreen(null));
        }
        while (keyShowOverlay.method_1436()) {
            if (config.getGeneral().getDisplayMode() != IWailaConfig.General.DisplayMode.TOGGLE) continue;
            config.getGeneral().setDisplayTooltip(!config.getGeneral().isDisplayTooltip());
        }
        while (keyToggleLiquid.method_1436()) {
            PluginConfig.set(WailaConstants.CONFIG_SHOW_FLUID, !PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_FLUID));
        }
        if (recipeAction != null) {
            while (keyShowRecipeInput.method_1436()) {
                recipeAction.showInput(DataAccessor.INSTANCE.getStack());
            }
            while (keyShowRecipeOutput.method_1436()) {
                recipeAction.showOutput(DataAccessor.INSTANCE.getStack());
            }
        }
    }

    protected static void onItemTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                String name = listener.getHoveredItemModName(stack, PluginConfig.CLIENT);
                if (name == null) continue;
                tooltip.add(IWailaConfig.get().getFormatter().modName(name));
                return;
            }
        }
    }

    protected static void onServerLogIn(class_2535 connection) {
        Waila.BLACKLIST_CONFIG.invalidate();
        PluginConfig.getSyncableConfigs().forEach(config -> config.setServerValue(null));
    }

    protected static void onServerLogout(class_2535 connection) {
        Waila.BLACKLIST_CONFIG.invalidate();
        PluginConfig.getSyncableConfigs().forEach(config -> config.setServerValue(null));
    }

    private static class_304 createKeyBind(String id) {
        return IClientService.INSTANCE.createKeyBind(id, class_3675.field_16237.method_1444());
    }

    static {
        showComponentBounds = false;
    }
}

