/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.item;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.PatchouliItems;

public class ItemModBook
extends class_1792 {
    public static final String TAG_BOOK = "patchouli:book";

    public ItemModBook() {
        super(new class_1792.class_1793().method_7889(1).method_7892(class_1761.field_7932));
    }

    public static float getCompletion(class_1799 stack) {
        Book book = ItemModBook.getBook(stack);
        float progression = 0.0f;
        if (book != null) {
            int totalEntries = 0;
            int unlockedEntries = 0;
            for (BookEntry entry : book.getContents().entries.values()) {
                if (entry.isSecret()) continue;
                ++totalEntries;
                if (entry.isLocked()) continue;
                ++unlockedEntries;
            }
            progression = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
        }
        return progression;
    }

    public static class_1799 forBook(Book book) {
        return ItemModBook.forBook(book.id);
    }

    public static class_1799 forBook(class_2960 book) {
        class_1799 stack = new class_1799((class_1935)PatchouliItems.BOOK);
        class_2487 cmp = new class_2487();
        cmp.method_10582(TAG_BOOK, book.toString());
        stack.method_7980(cmp);
        return stack;
    }

    public void method_7850(class_1761 tab, class_2371<class_1799> items) {
        String tabName = tab.method_7751();
        BookRegistry.INSTANCE.books.values().forEach(b -> {
            if (!(b.noBook || b.isExtension || tab != class_1761.field_7915 && !b.creativeTab.equals(tabName))) {
                items.add((Object)ItemModBook.forBook(b));
            }
        });
    }

    public String getCreatorModId(class_1799 stack) {
        Book book = ItemModBook.getBook(stack);
        if (book != null) {
            return book.owner.getId();
        }
        return class_2378.field_11142.method_10221((Object)this).method_12836();
    }

    public static Book getBook(class_1799 stack) {
        class_2960 res = ItemModBook.getBookId(stack);
        if (res == null) {
            return null;
        }
        return BookRegistry.INSTANCE.books.get(res);
    }

    private static class_2960 getBookId(class_1799 stack) {
        if (!stack.method_7985() || !stack.method_7969().method_10545(TAG_BOOK)) {
            return null;
        }
        String bookStr = stack.method_7969().method_10558(TAG_BOOK);
        return class_2960.method_12829((String)bookStr);
    }

    public class_2561 method_7864(class_1799 stack) {
        Book book = ItemModBook.getBook(stack);
        if (book != null) {
            return class_2561.method_43471((String)book.name);
        }
        return super.method_7864(stack);
    }

    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        Book book;
        super.method_7851(stack, worldIn, tooltip, flagIn);
        class_2960 rl = ItemModBook.getBookId(stack);
        if (flagIn.method_8035()) {
            tooltip.add((class_2561)class_2561.method_43470((String)("Book ID: " + rl)).method_27692(class_124.field_1080));
        }
        if ((book = ItemModBook.getBook(stack)) != null && !book.getContents().isErrored()) {
            tooltip.add((class_2561)book.getSubtitle().method_27692(class_124.field_1080));
        } else if (book == null) {
            if (rl == null) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.patchouli.guide_book.undefined").method_27692(class_124.field_1063));
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.patchouli.guide_book.invalid", (Object[])new Object[]{rl}).method_27692(class_124.field_1063));
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 stack = playerIn.method_5998(handIn);
        Book book = ItemModBook.getBook(stack);
        if (book == null) {
            return new class_1271(class_1269.field_5814, (Object)stack);
        }
        if (playerIn instanceof class_3222) {
            PatchouliAPI.get().openBookGUI((class_3222)playerIn, book.id);
            class_3414 sfx = PatchouliSounds.getSound(book.openSound, PatchouliSounds.BOOK_OPEN);
            playerIn.method_5783(sfx, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return new class_1271(class_1269.field_5812, (Object)stack);
    }
}

