/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.common.book.Book;

public class GuiButtonBookMarkRead
extends GuiButtonBook {
    private final Book book;

    public GuiButtonBookMarkRead(GuiBook parent, int x, int y) {
        super(parent, x, y, 308, 31, 11, 11, class_4185::method_25306, GuiButtonBookMarkRead.getTooltip(parent.book));
        this.book = parent.book;
    }

    @Override
    public void method_25359(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        int px = this.field_22760 + 1;
        int py = (int)((double)this.field_22761 + 0.5);
        GuiBook.drawFromTexture(ms, this.book, this.field_22760, this.field_22761, 285, 160, 13, 10);
        GuiBook.drawFromTexture(ms, this.book, px, py, this.u, this.v, this.field_22758, this.field_22759);
        if (this.method_25367()) {
            GuiBook.drawFromTexture(ms, this.book, px, py, this.u + 11, this.v, this.field_22758, this.field_22759);
            this.parent.setTooltip(this.getTooltip());
        }
        this.parent.getMinecraft().field_1772.method_1720(ms, "+", (float)px - 0.5f, (float)py - 0.2f, 65281);
    }

    public void method_25306() {
        for (BookEntry entry : this.book.getContents().entries.values()) {
            if (GuiButtonBookMarkRead.isMainPage(this.book)) {
                this.markEntry(entry);
                continue;
            }
            this.markCategoryAsRead(entry, entry.getCategory(), this.book.getContents().entries.size());
        }
    }

    private void markCategoryAsRead(BookEntry entry, BookCategory category, int maxRecursion) {
        if (category.getName().equals((Object)this.book.getContents().getCurrentGui().method_25440())) {
            this.markEntry(entry);
        } else if (!category.isRootCategory() && maxRecursion > 0) {
            this.markCategoryAsRead(entry, entry.getCategory().getParentCategory(), maxRecursion - 1);
        }
    }

    private void markEntry(BookEntry entry) {
        boolean dirty = false;
        class_2960 key = entry.getId();
        if (!entry.isLocked() && entry.getReadState().equals((Object)EntryDisplayState.UNREAD)) {
            PersistentData.BookData data = PersistentData.data.getBookData(this.book);
            if (!data.viewedEntries.contains(key)) {
                data.viewedEntries.add(key);
                dirty = true;
                entry.markReadStateDirty();
            }
        }
        if (dirty) {
            PersistentData.save();
        }
    }

    private static class_2561 getTooltip(Book book) {
        String text = GuiButtonBookMarkRead.isMainPage(book) ? "patchouli.gui.lexicon.button.mark_all_read" : "patchouli.gui.lexicon.button.mark_category_read";
        return class_2561.method_43471((String)text);
    }

    private static boolean isMainPage(Book book) {
        return !book.getContents().currentGui.canSeeBackButton();
    }
}

