/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.common.book.Book;

public final class BookContentResourceDirectLoader
implements BookContentLoader {
    public static final BookContentResourceDirectLoader INSTANCE = new BookContentResourceDirectLoader();

    private BookContentResourceDirectLoader() {
    }

    @Override
    public void findFiles(Book book, String dir, List<class_2960> list) {
        String prefix = String.format("%s/%s/%s/%s", "patchouli_books", book.id.method_12832(), "en_us", dir);
        Set files = class_310.method_1551().method_1478().method_14488(prefix, p -> p.method_12832().endsWith(".json")).keySet();
        files.stream().distinct().filter(file -> file.method_12836().equals(book.id.method_12836())).map(file -> {
            Preconditions.checkArgument((boolean)file.method_12832().startsWith(prefix));
            Preconditions.checkArgument((boolean)file.method_12832().endsWith(".json"));
            String newPath = file.method_12832().substring(prefix.length(), file.method_12832().length() - ".json".length());
            if (newPath.startsWith("/")) {
                newPath = newPath.substring(1);
            }
            return new class_2960(file.method_12836(), newPath);
        }).forEach(list::add);
    }

    @Override
    @Nullable
    public JsonElement loadJson(Book book, class_2960 file, @Nullable class_2960 fallback) {
        PatchouliAPI.LOGGER.debug("Loading {}", (Object)file);
        class_3300 manager = class_310.method_1551().method_1478();
        try {
            Optional resource = manager.method_14486(file);
            if (resource.isPresent()) {
                return BookContentLoader.streamToJson(((class_3298)resource.get()).method_14482());
            }
            if (fallback != null && (resource = manager.method_14486(fallback)).isPresent()) {
                return BookContentLoader.streamToJson(((class_3298)resource.get()).method_14482());
            }
            return null;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

