/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common;

import architectury_inject_lightoverlay_common_8a3571216ab54284b2725f771eb23314_41975f1901138958ec77525451cba23330df8f0120716052f55e8eb9d66a8969lightoverlay700devjar.PlatformMethods;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.lightoverlay.common.CubicChunkPos;
import me.shedaniel.lightoverlay.common.LightOverlay;
import me.shedaniel.lightoverlay.common.LightOverlayTicker;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class LightOverlayRenderer
implements Consumer<class_4587> {
    private final class_310 minecraft = class_310.method_1551();
    public class_4604 frustum;
    public LightOverlayTicker ticker;
    private static final Supplier<MethodHandle> IS_FRUSTUM_VISIBLE = Suppliers.memoize(() -> {
        try {
            return MethodHandles.lookup().findStatic(Class.forName("me.shedaniel.lightoverlay." + PlatformMethods.getCurrentTarget() + ".LightOverlayImpl"), "isFrustumVisible", MethodType.methodType(Boolean.TYPE, class_4604.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    });

    public LightOverlayRenderer(LightOverlayTicker ticker) {
        this.ticker = ticker;
    }

    @Override
    public void accept(class_4587 poses) {
        if (LightOverlay.enabled) {
            class_746 playerEntity = this.minecraft.field_1724;
            class_2338 playerPos = new class_2338(playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321());
            int playerPosX = playerPos.method_10263() >> 4;
            int playerPosY = playerPos.method_10264() >> 5;
            int playerPosZ = playerPos.method_10260() >> 4;
            class_3726 collisionContext = class_3726.method_16195((class_1297)playerEntity);
            class_4184 camera = this.minecraft.field_1773.method_19418();
            int chunkRange = LightOverlay.getChunkRange();
            if (LightOverlay.showNumber) {
                this.renderLevels(new class_4587(), camera, playerPos, playerPosX, playerPosY, playerPosZ, chunkRange, collisionContext);
            } else {
                this.renderCrosses(poses, camera, playerPos, playerPosX, playerPosY, playerPosZ, chunkRange, collisionContext);
            }
        }
    }

    private void renderLevels(class_4587 poses, class_4184 camera, class_2338 playerPos, int playerPosX, int playerPosY, int playerPosZ, int chunkRange, class_3726 collisionContext) {
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2338.class_2339 downMutable = new class_2338.class_2339();
        class_4597.class_4598 source = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        for (Map.Entry<CubicChunkPos, Long2ByteMap> entry : this.ticker.CHUNK_MAP.entrySet()) {
            CubicChunkPos chunkPos = entry.getKey();
            if (LightOverlay.caching && (class_3532.method_15382((int)(chunkPos.x - playerPosX)) > chunkRange || class_3532.method_15382((int)(chunkPos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || class_3532.method_15382((int)(chunkPos.z - playerPosZ)) > chunkRange)) continue;
            for (Long2ByteMap.Entry objectEntry : entry.getValue().long2ByteEntrySet()) {
                mutable.method_16363(objectEntry.getLongKey());
                if (!mutable.method_19771((class_2382)playerPos, (double)LightOverlay.reach) || !this.isFrustumVisible(mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), mutable.method_10263() + 1, mutable.method_10263() + 1, mutable.method_10263() + 1)) continue;
                downMutable.method_10103(mutable.method_10263(), mutable.method_10264() - 1, mutable.method_10260());
                this.renderLevel(poses, source, camera, (class_1937)this.minecraft.field_1687, (class_2338)mutable, (class_2338)downMutable, objectEntry.getByteValue(), collisionContext);
            }
        }
        RenderSystem.enableDepthTest();
        source.method_22993();
    }

    public void renderLevel(class_4587 poses, class_4597.class_4598 source, class_4184 camera, class_1937 world, class_2338 pos, class_2338 down, byte level, class_3726 collisionContext) {
        String text = String.valueOf(level);
        class_327 font = this.minecraft.field_1772;
        double cameraX = camera.method_19326().field_1352;
        double cameraY = camera.method_19326().field_1351;
        class_265 upperOutlineShape = world.method_8320(down).method_26172((class_1922)world, down, collisionContext);
        if (!upperOutlineShape.method_1110()) {
            cameraY += 1.0 - upperOutlineShape.method_1105(class_2350.class_2351.field_11052);
        }
        double cameraZ = camera.method_19326().field_1350;
        poses.method_22903();
        poses.method_22904((double)pos.method_10263() + 0.5 - cameraX, (double)pos.method_10264() - cameraY + 0.005, (double)pos.method_10260() + 0.5 - cameraZ);
        poses.method_22907(class_1160.field_20703.method_23214(90.0f));
        float size = 0.07f;
        poses.method_22905(-size, -size, size);
        float float_3 = (float)(-font.method_1727(text)) / 2.0f + 0.4f;
        font.method_27521(text, float_3, -3.5f, level > LightOverlay.higherCrossLevel ? -16505852 : (LightOverlay.lowerCrossLevel >= 0 && level > LightOverlay.lowerCrossLevel ? -16750849 : -9236207), false, poses.method_23760().method_23761(), (class_4597)source, false, 0, 0xF000F0);
        poses.method_22909();
    }

    private void renderCrosses(class_4587 poses, class_4184 camera, class_2338 playerPos, int playerPosX, int playerPosY, int playerPosZ, int chunkRange, class_3726 collisionContext) {
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.disableBlend();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.lineWidth((float)LightOverlay.lineWidth);
        class_289 tesselator = class_289.method_1348();
        class_287 builder = tesselator.method_1349();
        builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (Map.Entry<CubicChunkPos, Long2ByteMap> entry : this.ticker.CHUNK_MAP.entrySet()) {
            CubicChunkPos chunkPos = entry.getKey();
            if (LightOverlay.caching && (class_3532.method_15382((int)(chunkPos.x - playerPosX)) > chunkRange || class_3532.method_15382((int)(chunkPos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || class_3532.method_15382((int)(chunkPos.z - playerPosZ)) > chunkRange)) continue;
            for (Long2ByteMap.Entry objectEntry : entry.getValue().long2ByteEntrySet()) {
                byte crossType = objectEntry.getByteValue();
                mutable.method_16363(objectEntry.getLongKey());
                if (!mutable.method_19771((class_2382)playerPos, (double)LightOverlay.reach) || !this.isFrustumVisible(mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), mutable.method_10263() + 1, mutable.method_10263() + 1, mutable.method_10263() + 1)) continue;
                int color = switch (crossType) {
                    case 1 -> LightOverlay.redColor;
                    case 0 -> LightOverlay.yellowColor;
                    default -> LightOverlay.secondaryColor;
                };
                this.renderCross(poses.method_23760().method_23761(), builder, camera, (class_1937)this.minecraft.field_1687, (class_2338)mutable, color, collisionContext);
            }
        }
        tesselator.method_1350();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
    }

    public void renderCross(class_1159 pose, class_287 builder, class_4184 camera, class_1937 world, class_2338 pos, int color, class_3726 collisionContext) {
        double cameraX = camera.method_19326().field_1352;
        double cameraY = camera.method_19326().field_1351 - 0.005;
        double blockOffset = 0.0;
        class_265 upperOutlineShape = world.method_8320(pos).method_26172((class_1922)world, pos, collisionContext);
        if (!upperOutlineShape.method_1110()) {
            blockOffset += upperOutlineShape.method_1105(class_2350.class_2351.field_11052);
        }
        double cameraZ = camera.method_19326().field_1350;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        double x = (double)pos.method_10263() - cameraX;
        double y = (double)pos.method_10264() - cameraY + blockOffset;
        double z = (double)pos.method_10260() - cameraZ;
        builder.method_22912(x + 0.01, y, z + 0.01).method_1336(red, green, blue, 255).method_1344();
        builder.method_22912(x + 0.99, y, z + 0.99).method_1336(red, green, blue, 255).method_1344();
        builder.method_22912(x + 0.99, y, z + 0.01).method_1336(red, green, blue, 255).method_1344();
        builder.method_22912(x + 0.01, y, z + 0.99).method_1336(red, green, blue, 255).method_1344();
    }

    public boolean isFrustumVisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            return this.frustum == null || IS_FRUSTUM_VISIBLE.get().invokeExact(this.frustum, minX, minY, minZ, maxX, maxY, maxZ);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

